/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_mux7 ( result, sel, data6x, data5x, data4x, data3x, data2x, data1x, data0x ) ;

  parameter lpm_type = "lpm_mux" ;
  parameter lpm_size = 7 ;
  parameter lpm_width = 1 ;
  parameter lpm_widths = 3 ;
  parameter polar_sel = "NORMAL" ;
  parameter polar_data6x = "NORMAL" ;
  parameter polar_data5x = "NORMAL" ;
  parameter polar_data4x = "NORMAL" ;
  parameter polar_data3x = "NORMAL" ;
  parameter polar_data2x = "NORMAL" ;
  parameter polar_data1x = "NORMAL" ;
  parameter polar_data0x = "NORMAL" ;
  parameter polar_result = "NORMAL" ;

  input  [lpm_widths-1:0] sel ;
  input  [lpm_width-1:0] data6x ;
  input  [lpm_width-1:0] data5x ;
  input  [lpm_width-1:0] data4x ;
  input  [lpm_width-1:0] data3x ;
  input  [lpm_width-1:0] data2x ;
  input  [lpm_width-1:0] data1x ;
  input  [lpm_width-1:0] data0x ;
  output [lpm_width-1:0] result ;

  reg  [lpm_widths-1:0] psel ;
  reg  [lpm_width-1:0] pdata6x, pdata5x, pdata4x, pdata3x, pdata2x, pdata1x,pdata0x ;
  reg  [lpm_width-1:0] tmp_result ;
  reg  [lpm_width-1:0] UNKNOWN ;
  integer i;

  initial
    begin
        // check if widths is out of bound
        if((1<< lpm_widths) < lpm_size)
            $display("Error! lpm_widths must be >= 3.\n");
        else if(lpm_widths < 0)
            $display("Error! lpm_widths must be a positive value.\n");
 
		for( i = 0; i < lpm_width; i=i+1)
			UNKNOWN[i] = 1'bx;
	end
 
  always @(sel or data6x or data5x or data4x or data3x or data2x or data1x or data0x)
    begin
       psel <= #1 (polar_sel=="INVERT")?~sel:sel ;
       pdata6x <= #1 (polar_data6x=="INVERT")?~data6x:data6x ;
       pdata5x <= #1 (polar_data5x=="INVERT")?~data5x:data5x ;
       pdata4x <= #1 (polar_data4x=="INVERT")?~data4x:data4x ;
       pdata3x <= #1 (polar_data3x=="INVERT")?~data3x:data3x ;
       pdata2x <= #1 (polar_data2x=="INVERT")?~data2x:data2x ;
       pdata1x <= #1 (polar_data1x=="INVERT")?~data1x:data1x ;
       pdata0x <= #1 (polar_data0x=="INVERT")?~data0x:data0x ;
    end

  always @(psel or pdata6x or pdata5x or pdata4x or pdata3x or pdata2x or pdata1x or pdata0x)
    begin
       case(psel)
			3'b000: tmp_result = pdata0x ;
			3'b001: tmp_result = pdata1x ;
			3'b010: tmp_result = pdata2x ;
			3'b011: tmp_result = pdata3x ;
			3'b100: tmp_result = pdata4x ;
			3'b101: tmp_result = pdata5x ;
			3'b110: tmp_result = pdata6x ;
		  default: tmp_result = UNKNOWN ;
	   endcase
	end

	assign result = (polar_result=="INVERT")?~tmp_result:tmp_result ;

endmodule // lpm_mux7
`ifdef SYNTH
`else
`endcelldefine
`endif

